import {ReactNode, useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import RadioButtonSlide, {IRadioButtonSlideProps} from './RadioButtonSlide';

export default {
    title: 'Example/RadioButtonSlide',
    component: RadioButtonSlide,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [value, setValue] = useState('1');

    return (
        <div style={{width: '300px'}}>
            <RadioButtonSlide name="simple" value={value} onChange={setValue}>
                <RadioButtonSlide.Option value="1">1</RadioButtonSlide.Option>
                <RadioButtonSlide.Option value="2">2</RadioButtonSlide.Option>
                <RadioButtonSlide.Option value="3">3</RadioButtonSlide.Option>
            </RadioButtonSlide>
        </div>
    );
};

export const Disabled: TStorybookFunctionComponent = () => {
    const [value, setValue] = useState('2');

    return (
        <Box between="2">
            <div style={{width: '300px'}}>
                <RadioButtonSlide name="disabledFull" disabled value="1">
                    <RadioButtonSlide.Option value="1">
                        1
                    </RadioButtonSlide.Option>
                    <RadioButtonSlide.Option value="2">
                        2
                    </RadioButtonSlide.Option>
                    <RadioButtonSlide.Option value="3">
                        3
                    </RadioButtonSlide.Option>
                </RadioButtonSlide>
            </div>
            <div style={{width: '300px'}}>
                <RadioButtonSlide
                    name="disabledPartial"
                    value={value}
                    onChange={setValue}
                >
                    <RadioButtonSlide.Option value="1" disabled>
                        1
                    </RadioButtonSlide.Option>
                    <RadioButtonSlide.Option value="2">
                        2
                    </RadioButtonSlide.Option>
                    <RadioButtonSlide.Option value="3">
                        3
                    </RadioButtonSlide.Option>
                </RadioButtonSlide>
            </div>
        </Box>
    );
};

const sizeTemplate = (size: IRadioButtonSlideProps['size']): ReactNode => (
    <div style={{width: '300px'}}>
        <RadioButtonSlide name={size} size={size} value="1">
            <RadioButtonSlide.Option value="1">1</RadioButtonSlide.Option>
            <RadioButtonSlide.Option value="2">2</RadioButtonSlide.Option>
            <RadioButtonSlide.Option value="3">3</RadioButtonSlide.Option>
        </RadioButtonSlide>
    </div>
);

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 'm',
                example: sizeTemplate('m'),
            },
            {
                name: 'l',
                example: sizeTemplate('l'),
            },
        ]}
    />
);
