import {ReactNode, useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';

import Radiobox from './Radiobox';

export default {
    title: 'Example/Radiobox',
    component: Radiobox,
} as Meta;

export const State: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={[
            {
                name: 'Default',
                props: {},
                example: (
                    <Radiobox
                        options={[{label: 'Радио 1', value: 'value1'}]}
                        onChange={noop}
                    />
                ),
            },
            {
                name: 'Checked',
                props: {value: 'value2'},
                example: (
                    <Radiobox
                        value="value2"
                        options={[{label: 'Радио 2', value: 'value2'}]}
                        onChange={noop}
                    />
                ),
            },
            {
                name: 'Disabled',
                props: {'options[].disabled': true},
                example: (
                    <Radiobox
                        options={[
                            {
                                label: 'Радио 3',
                                value: 'value3',
                                disabled: true,
                            },
                        ]}
                        onChange={noop}
                    />
                ),
            },
            {
                name: 'Disabled checked',
                props: {value: 'value4', 'options[].disabled': true},
                example: (
                    <Radiobox
                        value="value4"
                        options={[
                            {
                                label: 'Радио 4',
                                value: 'value4',
                                disabled: true,
                            },
                        ]}
                        onChange={noop}
                    />
                ),
            },
        ]}
    />
);

export const Size: TStorybookFunctionComponent = () => {
    const [sValue, sSetValue] = useState<string>();

    return (
        <StyleguidistSizeTable
            sizes={[
                {
                    name: 's',
                    example: (
                        <Radiobox
                            value={sValue}
                            options={[
                                {label: 'Радио 1', value: 'value1'},
                                {
                                    label: 'Радио 2',
                                    value: 'value2',
                                },
                                {label: 'Радио 3', value: 'value3'},
                            ]}
                            onChange={(e): void => sSetValue(e.target.value)}
                            name="1"
                            size="s"
                        />
                    ),
                },
                {
                    name: 'm',
                    comment: 'default',
                    example: (
                        <Radiobox
                            value={sValue}
                            options={[
                                {label: 'Радио 1', value: 'value1'},
                                {
                                    label: 'Радио 2',
                                    value: 'value2',
                                },
                                {label: 'Радио 3', value: 'value3'},
                            ]}
                            onChange={(e): void => sSetValue(e.target.value)}
                            name="1"
                        />
                    ),
                },
            ]}
        />
    );
};

export const Multiline: TStorybookFunctionComponent = () => (
    <div style={{width: '200px'}}>
        <Radiobox
            options={[
                {
                    label: 'Радио Радио Радио Радио Радио Радио 1',
                    value: 'value1',
                },
                {label: 'Радио 2', value: 'value2'},
                {
                    label: 'Радио Радио Радио Радио Радио Радио Радио Радио Радио Радио Радио 3',
                    value: 'value3',
                },
            ]}
        />
    </div>
);

const complexRadioLabel = (
    title: string,
    subtitle: string,
    description: string,
): ReactNode => (
    <div>
        <h3 style={{margin: 0}}>{title}</h3>
        <b>{subtitle}</b>
        <p style={{margin: 0}}>{description}</p>
    </div>
);

export const ComplexLabel: TStorybookFunctionComponent = () => (
    <Radiobox
        options={[
            {
                label: complexRadioLabel(
                    'Эконом',
                    '500₽',
                    'Без багажа, возврат запрещен',
                ),
                value: 'value1',
            },
            {
                label: complexRadioLabel(
                    'Бизнес',
                    '6500₽',
                    '1 место багажа 23 кг., возврат запрещен',
                ),
                value: 'value2',
            },
            {
                label: complexRadioLabel(
                    'Премиум',
                    '24500₽',
                    '3 места багажа 100 кг., возврат разрешен',
                ),
                value: 'value3',
            },
        ]}
    />
);
