import {FunctionComponent} from 'react';
import {isNumber} from 'lodash';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

/* Init Styles */
import cx from './Rating.scss';

const getRatingMod = (rating: number) => {
    switch (true) {
        case rating >= 4: {
            return 'great';
        }

        case rating >= 3: {
            return 'fine';
        }

        case rating >= 1: {
            return 'good';
        }

        default: {
            return 'none';
        }
    }
};

export interface IRatingProps extends IWithClassName, IWithQaAttributes {
    rating: number | null;
    text?: string;
    size: 's' | 'm' | 'l';
}

const Rating: FunctionComponent<IRatingProps> = props => {
    const {rating, size = 's', className, text} = props;

    if (!isNumber(rating)) {
        return null;
    }

    return (
        <div
            className={cx(
                'root',
                `root_size_${size}`,
                `root_theme_${getRatingMod(rating)}`,
                className,
            )}
            {...prepareQaAttributes(props)}
        >
            {text || rating.toFixed(1).replace('.', ',')}
        </div>
    );
};

export default Rating;
