import React, {useCallback, useMemo} from 'react';

import StarOutlineIcon from 'icons/36/StarOutline';
import StarIcon from 'icons/36/Star';

import cx from './RatingStar.scss';

interface IRatingStarProps {
    index: number;
    isHovered: boolean;
    isSelected: boolean;
    onMouseEnter: (index: number) => void;
    onMouseLeave: (index: number) => void;
    onClick?: (index: number) => void;
}

const RatingStar: React.FC<IRatingStarProps> = ({
    index,
    isHovered,
    isSelected,
    onMouseEnter,
    onMouseLeave,
    onClick,
}) => {
    const handleMouseEnter = useCallback(() => {
        onMouseEnter(index);
    }, [index, onMouseEnter]);
    const handleMouseLeave = useCallback(() => {
        onMouseLeave(index);
    }, [index, onMouseLeave]);
    const handleClick = useCallback(() => {
        onClick?.(index);
    }, [index, onClick]);

    const Icon = useMemo(
        () => (isSelected ? StarIcon : StarOutlineIcon),
        [isSelected],
    );

    return (
        <Icon
            className={cx('root', {root_yellow: isHovered || isSelected})}
            onMouseEnter={handleMouseEnter}
            onMouseLeave={handleMouseLeave}
            onClick={handleClick}
        />
    );
};

export default RatingStar;
