import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import Price from 'components/Price/Price';

import Recipe, {IRecipeProps} from './Recipe';

export default {
    title: 'Example/Recipe',
    component: Recipe,
} as Meta;

const template = (type: IRecipeProps['type']) => (
    <div style={{display: 'flex', overflow: 'auto'}}>
        <div style={{margin: 10, flex: 1}}>
            <h3>В другой город</h3>
            <Recipe
                project="Авиабилеты"
                imageUrl="https://avatars.mds.yandex.net/get-avia/244263/2a0000015ca818f0a0bbc5d0c6affef72a6a/offer-desktop-wide"
                fromTitle="Вылет из Москвы"
                targetCity="Сочи"
                dateFrom="2018-12-21"
                dateTo="2018-12-28"
                price={
                    <>
                        от <Price currency={CurrencyType.RUR} value={1108} />
                    </>
                }
                type={type}
                href={document.location.href}
            />
        </div>
        <div style={{margin: 10, flex: 1}}>
            <h3>В другую страну</h3>
            <Recipe
                project="Авиабилеты"
                imageUrl="https://avatars.mds.yandex.net/get-avia/233213/2a0000015a804658335a9ecdc825ab9bb534/offer-desktop-wide"
                fromTitle="Вылет из Москвы"
                targetCity="Барселона"
                targetCountry="Испания"
                dateFrom="2018-12-21"
                dateTo="2018-12-28"
                price={
                    <>
                        от <Price currency={CurrencyType.RUR} value={5555} />
                    </>
                }
                type={type}
                href={document.location.href}
            />
        </div>
    </div>
);

export const Normal: TStorybookFunctionComponent = () => template('normal');

export const Wide: TStorybookFunctionComponent = () => template('wide');
Wide.parameters = {
    info: {
        title: 'Узкая плашка',
    },
};

export const Wider: TStorybookFunctionComponent = () => template('wider');
Wider.parameters = {
    info: {
        title: 'Узкая плашка пошире',
    },
};

export const Ultrawide: TStorybookFunctionComponent = () =>
    template('ultrawide');
Ultrawide.parameters = {
    info: {
        title: 'Широкая плашка',
    },
};

export const Mobile: TStorybookFunctionComponent = () => template('mobile');
Ultrawide.parameters = {
    info: {
        title: 'Плашка в таче',
    },
};
