import {FunctionComponent, ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Recipe from 'components/Recipe/Recipe';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

import recipes from './__docs__/recipes';
import RecipeGrid from './RecipeGrid';

export default {
    title: 'Example/RecipeGrid',
    component: RecipeGrid,
} as Meta;

interface ITemplateProps {
    count: number;
}

const Template: FunctionComponent<ITemplateProps> = ({count}) => (
    <DeviceTypeContext.Consumer>
        {(deviceType): ReactNode => (
            <RecipeGrid
                deviceType={deviceType}
                recipesData={recipes.slice(0, count)}
                renderRecipe={(data, type, idx): ReactNode => (
                    <Recipe key={idx} {...data} type={type} />
                )}
            />
        )}
    </DeviceTypeContext.Consumer>
);

export const Single: TStorybookFunctionComponent = () => <Template count={1} />;

export const Double: TStorybookFunctionComponent = () => <Template count={2} />;

export const Triple: TStorybookFunctionComponent = () => <Template count={3} />;

export const Quadruple: TStorybookFunctionComponent = () => (
    <Template count={4} />
);

export const Quintuple: TStorybookFunctionComponent = () => (
    <Template count={5} />
);

export const Many: TStorybookFunctionComponent = () => <Template count={11} />;
