import {IWithClassName} from 'types/withClassName';
import {ISimpleTextReview} from 'types/common/ISimpleTextReview';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';
import Separator from 'components/Separator/Separator';
import Intersperse from 'components/Intersperse/Intersperse';
import Review from 'components/Reviews/components/Review/Review';

interface IReviewsProps extends IWithClassName {
    title?: string;
    reviews: ISimpleTextReview[];
}

const Reviews: React.FC<IReviewsProps> = props => {
    const deviceType = useDeviceType();
    const {className, title, reviews} = props;

    if (!reviews.length) {
        return null;
    }

    return (
        <Box className={className} between="6">
            {title && <Heading level={2}>{title}</Heading>}

            {deviceType.isDesktop ? (
                <Box between="3">
                    <Intersperse separator={<Separator />}>
                        {reviews.map((review, index) => (
                            <Review key={index} {...review} />
                        ))}
                    </Intersperse>
                </Box>
            ) : (
                <Box between="6">
                    {reviews.map((review, index) => (
                        <Review key={index} {...review} />
                    ))}
                </Box>
            )}
        </Box>
    );
};

export default Reviews;
