import {ISimpleTextReview} from 'types/common/ISimpleTextReview';

import {formatDate} from 'utilities/dateUtils';
import {HUMAN_WITH_YEAR} from 'utilities/dateUtils/formats';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import Stars from 'components/Stars/Stars';

interface IReviewProps extends ISimpleTextReview {}

const Review: React.FC<IReviewProps> = props => {
    const {updatedAt, title, text, rating} = props;
    const {isMobile} = useDeviceType();

    return (
        <Box between="3">
            <Flex inline nowrap between="2" alignItems="center">
                <Stars totalStarCount={5} starCount={rating} />
                <Text color="secondary">
                    {formatDate(updatedAt, HUMAN_WITH_YEAR)}
                </Text>
            </Flex>

            <Flex flexDirection="column" between={isMobile ? 1 : 0}>
                {title && <Text color="secondary">{title}</Text>}
                <Text>{text}</Text>
            </Flex>
        </Box>
    );
};

export default Review;
