import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useToggle} from 'utilities/hooks/useToggle';

import Button from 'components/Button/Button';

import RotatingArrowIcon from './RotatingArrowIcon';

export default {
    title: 'Example/RotatingArrowIcon',
    component: RotatingArrowIcon,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <>
        <RotatingArrowIcon rotated={false} />
        <RotatingArrowIcon rotated />
    </>
);

export const Dynamic: TStorybookFunctionComponent = () => {
    const [isRotated, toggle] = useToggle(false);

    return (
        <Button onClick={toggle}>
            <RotatingArrowIcon rotated={isRotated} />
        </Button>
    );
};
