import React, {FunctionComponent} from 'react';

import {IIconProps} from 'icons/types/icon';

import ArrowBottomIcon from 'icons/16/ArrowBottom';

import cx from './RotatingArrowIcon.scss';

export interface IRotatingArrowIconProps extends IIconProps {
    Icon?: React.FC<IIconProps>;
    rotated: boolean;
}

const RotatingArrowIcon: FunctionComponent<IRotatingArrowIconProps> = ({
    className,
    Icon = ArrowBottomIcon,
    rotated = false,
    ...iconProps
}: IRotatingArrowIconProps) => {
    return (
        <Icon
            className={cx(
                'icon',
                {
                    icon_rotated: rotated,
                },
                className,
            )}
            {...iconProps}
        />
    );
};

export default RotatingArrowIcon;
