import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import ArrowLeftIcon from 'icons/16/ArrowLeft';
import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import RoundButton from './RoundButton';

export default {
    title: 'Example/RoundButton',
    component: RoundButton,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={[
            {
                name: 'White',
                props: {theme: 'white'},
                example: (
                    <Box between="5" inline>
                        <RoundButton>ОК</RoundButton>
                        <RoundButton icon={<ArrowLeftIcon />} />
                    </Box>
                ),
            },
            {
                name: 'Dark',
                props: {theme: 'dark'},
                example: (
                    <Box between="5" inline>
                        <RoundButton theme="dark">ОК</RoundButton>
                        <RoundButton theme="dark" icon={<ArrowLeftIcon />} />
                    </Box>
                ),
            },
        ]}
    />
);

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 's',
                size: '30px',
                example: <RoundButton size="s" icon={<ArrowLeftIcon />} />,
            },
            {
                name: 'm',
                size: '38px',
                example: <RoundButton size="m" icon={<ArrowLeftIcon />} />,
            },
        ]}
    />
);
