import React, {ChangeEventHandler} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18n from 'i18nNew/avia-SearchForm';

import RadioButton from 'components/RadioButton/RadioButton';
import Box from 'components/Box/Box';

interface IRoundTripProps {
    isRoundTrip: boolean;
    onChange(event: {target: {value: 'oneWay' | 'roundTrip'}}): void;
}

const RoundTripToggle: React.FC<IRoundTripProps> = props => {
    const {isRoundTrip, onChange} = props;

    const deviceType = useDeviceType();

    return (
        <Box x={4} above={4}>
            <RadioButton
                value={isRoundTrip ? 'roundTrip' : 'oneWay'}
                width="max"
                size={deviceType.isMobile ? 'l' : 'm'}
                onChange={onChange as ChangeEventHandler<HTMLInputElement>}
            >
                <RadioButton.Radio value="oneWay">
                    {i18n.oneWay()}
                </RadioButton.Radio>

                <RadioButton.Radio value="roundTrip">
                    {i18n.roundTrip()}
                </RadioButton.Radio>
            </RadioButton>
        </Box>
    );
};

export default React.memo(RoundTripToggle);
