import fs from 'fs';
import path from 'path';
import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import readAndJoinScriptsSync from 'utilities/readAndJoinScriptsSync/readAndJoinScriptsSync';
import getSettings from 'components/Rum/utilities/getSettings';
import getVariables from 'components/Rum/utilities/getVariables';
import getInitRumScripts from 'components/Rum/utilities/getInitRumScripts';

const ROOT_PATH = fs.realpathSync(process.cwd());

const DIST_PATH = path.join(
    ROOT_PATH,
    'node_modules',
    '@yandex-int',
    'rum-counter',
    'dist',
);
const INLINE_SCRIPTS_PATHS = [
    'interface.min.js',
    'longtask.min.js',
    'io.min.js',
].map(fileName => path.join(DIST_PATH, 'inline', fileName));

const INLINE_CONTENT_SCRIPTS = readAndJoinScriptsSync(INLINE_SCRIPTS_PATHS);

export interface IRumProps extends IWithDeviceType {
    geoId: number | undefined;
    nonce: string;
    environment: IAppData['appEnv'];
    reqPath: string;
    reqQuery: {
        when?: string;
        date?: string;
    };
}

const Rum: React.FC<IRumProps> = props => {
    const {nonce} = props;

    return (
        <>
            <script
                nonce={nonce}
                dangerouslySetInnerHTML={{
                    __html: INLINE_CONTENT_SCRIPTS,
                }}
            />

            <script
                nonce={nonce}
                dangerouslySetInnerHTML={{
                    __html: getInitRumScripts(
                        getSettings(),
                        getVariables(props),
                    ),
                }}
            />
        </>
    );
};

export default Rum;
