/* eslint-disable camelcase */
export enum ERumPage {
    AVIA_MAIN = 'avia.main',
    AVIA_DATE_SEARCH = 'avia.dateSearch',
    AVIA_ROUTE = 'avia.route',
    AVIA_FLIGHT = 'avia.flight',

    TRAINS_MAIN = 'trains.main',
    TRAINS_DIRECTION_SEARCH = 'trains.directionSearch',
    TRAINS_DATE_SEARCH = 'trains.dateSearch',
    TRAINS_POPULAR_ROUTES = 'trains.popularRoutes',

    HOTELS_MAIN = 'hotels.main',
    HOTELS_DATE_SEARCH = 'hotels.dateSearch',
    HOTELS_HOTEL = 'hotels.hotel',
    HOTELS_GEO_REGION = 'hotels.geoRegion',

    BUSES_MAIN = 'buses.main',
    BUSES_DIRECTION_SEARCH = 'buses.directionSearch',
    BUSES_DATE_SEARCH = 'buses.dateSearch',
    BUSES_CITY = 'buses.city',

    OTHER = 'other',
}

export interface IRumSettings {
    beacon: boolean;
    clck: string;
    reqid: string;
}

export interface IRumVariables {
    region: number | undefined;
    rum_id: string;
    '-project': string;
    '-page': ERumPage;
    '-env': 'development' | 'testing' | 'prestable' | 'production';
    '-version': string;
    '-platform': 'desktop' | 'mobile';
}
