import {FC} from 'react';
import Helmet from 'react-helmet';

import {IAggregateOfferMarkup} from 'components/SchemaMarkup/utilities/getAggregateOffer';
import {IFAQSchemaMarkup} from 'components/SchemaMarkup/utilities/getFAQSchemaMarkup';
import {IHotelSchemaMarkup} from 'components/SchemaMarkup/utilities/getHotelSchemaMarkup';
import {IBusesTripSchemaMarkup} from 'components/SchemaMarkup/utilities/getBusTripSchemaMarkup';
import {IBreadcrumbList} from 'components/LinkBreadcrumbs/utilities/getMetaBreadcrumbList';
import {IArticleSchemaMarkup} from 'components/SchemaMarkup/utilities/getArticleSchemaMarkup';

interface ISchemaMarkupProps {
    data:
        | IAggregateOfferMarkup
        | IFAQSchemaMarkup
        | IHotelSchemaMarkup
        | IBusesTripSchemaMarkup
        | IArticleSchemaMarkup
        | IBreadcrumbList;
    nonce: string;
}

const SchemaMarkup: FC<ISchemaMarkupProps> = props => (
    <Helmet>
        <script type="application/ld+json" nonce={props.nonce}>
            {JSON.stringify(props.data)}
        </script>
    </Helmet>
);

export default SchemaMarkup;

export {getAggregateOffer} from './utilities/getAggregateOffer';
export {getFAQSchemaMarkup} from './utilities/getFAQSchemaMarkup';
export {getHotelSchemaMarkup} from './utilities/getHotelSchemaMarkup';
export {getArticleSchemaMarkup} from './utilities/getArticleSchemaMarkup';
