import {CurrencyType} from 'utilities/currency/CurrencyType';
import ValueType from 'utilities/currency/ValueType';

import {IBaseMarkup, baseMarkup} from './baseMarkup';

export interface IAggregateOfferMarkup extends IBaseMarkup {
    '@type': 'Product';
    name: string;
    offers: IAggregateOffer;
}

export interface IAggregateOffer {
    '@type': 'AggregateOffer';
    url: string;
    lowPrice: number;
    priceCurrency: CurrencyType;
}

export interface IAggregateOfferData {
    name: string;
    url: string;
    price: {
        value: ValueType;
        currency: CurrencyType;
    };
}

/**
 * https://schema.org/AggregateOffer
 */
export function getAggregateOffer(
    data: IAggregateOfferData,
): IAggregateOfferMarkup {
    return {
        ...baseMarkup,
        '@type': 'Product',
        name: data.name,
        offers: {
            '@type': 'AggregateOffer',
            url: data.url,
            lowPrice: Number(data.price.value),
            priceCurrency: data.price.currency,
        },
    };
}
