import {
    baseMarkup,
    IBaseMarkup,
} from 'components/SchemaMarkup/utilities/baseMarkup';

export interface IArticleAuthorSchemaMarkup {
    '@type': 'Person';
    name: string;
    url?: string;
}

export interface IArticleSchemaMarkup extends IBaseMarkup {
    '@type': 'Article';
    headline: string;
    image?: string[];
    datePublished: string;
    dateModified: string;
    author: IArticleAuthorSchemaMarkup[];
}

interface IGetArticleSchemaMarkupParams {
    headline: string;
    image?: string[];
    datePublished: string;
    dateModified: string;
    author: {
        name: string;
        url?: string;
    }[];
}

export function getArticleSchemaMarkup({
    headline,
    image,
    author,
    dateModified,
    datePublished,
}: IGetArticleSchemaMarkupParams): IArticleSchemaMarkup {
    return {
        ...baseMarkup,
        '@type': 'Article',
        headline,
        image,
        datePublished,
        dateModified,
        author: author.map(item => ({
            '@type': 'Person',
            name: item.name,
            url: item.url,
        })),
    };
}
