import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import SearchButtonGroup from './SearchButtonGroup';

export default {
    title: 'Example/SearchButtonGroup',
    component: SearchButtonGroup,
} as Meta;

const ECONOMY_AVIA_CLASS = 'economy';
const BUSINESS_AVIA_CLASS = 'business';
const AVIA_CLASS_TYPES = [
    {
        value: ECONOMY_AVIA_CLASS,
        label: 'Эконом',
    },
    {
        value: BUSINESS_AVIA_CLASS,
        label: 'Бизнес',
    },
    {
        value: 'super-business',
        label: 'Супер-Бизнес',
    },
];

export const Simple: TStorybookFunctionComponent = () => {
    const [selectedItem, setItem] = useState(AVIA_CLASS_TYPES[0]);

    return (
        <div
            style={{
                display: 'flex',
                justifyContent: 'center',
                alignItems: 'center',
            }}
        >
            <SearchButtonGroup
                items={AVIA_CLASS_TYPES}
                onChange={setItem}
                activeElementValue={selectedItem.value}
            />
        </div>
    );
};
