import React from 'react';

import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import WhenButton from 'components/SearchForm/components/DatePicker/components/DatepickerToolbar/components/WhenButton/WhenButton';

import cx from './DatepickerToolbar.scss';

interface IDatepickerToolbarProps {
    specialWhenButtons: WHEN_SPECIAL_VALUE[];
    onClick(value: string): void;
}

const DatepickerToolbar: React.FC<IDatepickerToolbarProps> = props => {
    const {specialWhenButtons, onClick} = props;

    return (
        <div className={cx('root')}>
            {specialWhenButtons.map(specialWhen => (
                <WhenButton
                    key={specialWhen}
                    className={cx('button')}
                    value={specialWhen}
                    onClick={onClick}
                />
            ))}
        </div>
    );
};

export default DatepickerToolbar;
