import {useMemo, useRef} from 'react';

export default function useSearchSuggests<SuggestItem>(
    currentSuggests: SuggestItem[] | null | undefined,
): SuggestItem[] | null {
    const prevSuggestsRef = useRef<SuggestItem[] | null>(null);

    return useMemo(() => {
        if (currentSuggests) {
            prevSuggestsRef.current = currentSuggests;
        }

        return currentSuggests || prevSuggestsRef.current;
    }, [currentSuggests]);
}
