import {useRef} from 'react';

import {
    ESearchFormFieldName,
    TSearchFormTypeAndValue,
} from 'components/SearchForm/types';

import useImmutableCallback from 'utilities/hooks/useImmutableCallback';

import {ISuggestValue} from 'components/SearchSuggest/SearchSuggest';

interface IStoredFields {
    [ESearchFormFieldName.FROM]?: ISuggestValue<any>;
    [ESearchFormFieldName.TO]?: ISuggestValue<any>;
    [ESearchFormFieldName.START_DATE]?: string | null;
}

export default function useStoredFields({
    setFromPoint,
    setToPoint,
}: {
    setFromPoint?(point: ISuggestValue<any>): void;
    setToPoint?(point: ISuggestValue<any>): void;
}): {
    storeField(typeAndValue: TSearchFormTypeAndValue): void;
    storeFieldIfNotFilled(typeAndValue: TSearchFormTypeAndValue): void;
    restoreField(type: ESearchFormFieldName): void;
} {
    const storedFieldsRef = useRef<IStoredFields>({});

    const storeField = useImmutableCallback(
        (typeAndValue: TSearchFormTypeAndValue) => {
            if (
                typeAndValue.type === ESearchFormFieldName.FROM ||
                typeAndValue.type === ESearchFormFieldName.TO
            ) {
                storedFieldsRef.current[typeAndValue.type] = typeAndValue.value;
            } else if (typeAndValue.type === ESearchFormFieldName.START_DATE) {
                storedFieldsRef.current[typeAndValue.type] = typeAndValue.value;
            }
        },
    );

    const storeFieldIfNotFilled = useImmutableCallback(
        (typeAndValue: TSearchFormTypeAndValue) => {
            if (storedFieldsRef.current[typeAndValue.type] === undefined) {
                if (
                    typeAndValue.type === ESearchFormFieldName.FROM ||
                    typeAndValue.type === ESearchFormFieldName.TO
                ) {
                    storedFieldsRef.current[typeAndValue.type] =
                        typeAndValue.value;
                } else if (
                    typeAndValue.type === ESearchFormFieldName.START_DATE
                ) {
                    storedFieldsRef.current[typeAndValue.type] =
                        typeAndValue.value;
                }
            }
        },
    );

    const restoreField = useImmutableCallback((type: ESearchFormFieldName) => {
        if (
            type === ESearchFormFieldName.FROM ||
            type === ESearchFormFieldName.TO
        ) {
            const storedValue = storedFieldsRef.current[type];

            if (!storedValue) {
                return;
            }

            if (type === ESearchFormFieldName.FROM) {
                setFromPoint?.(storedValue);
            } else {
                setToPoint?.(storedValue);
            }
        }
    });

    return {
        storeField,
        storeFieldIfNotFilled,
        restoreField,
    };
}
