import React from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import Box from 'components/Box/Box';
import Flex from 'components/Flex/Flex';
import Price from 'components/Price/Price';
import Heading from 'components/Heading/Heading';
import BusIcon from 'icons/24/Bus';
import HotelIcon from 'icons/24/Hotel';
import TrainIcon from 'icons/24/Train';
import FlightIcon from 'icons/24/Flight';

import SearchPreset from './SearchPreset';

export default {
    title: 'Example/SearchPreset',
    component: SearchPreset,
} as Meta;

export const Types: TStorybookFunctionComponent = (): React.ReactElement => (
    <Flex style={{backgroundColor: 'white', padding: '20px'}}>
        <Heading level="3">Avia</Heading>
        <SearchPreset
            onClick={(): void => {}}
            title="Москва — Анапа"
            secondRow="4 пасажира"
            thirdRow="26 сен — 2 окт"
            Icon={FlightIcon}
        />
        <Heading level="3">Hotels</Heading>
        <SearchPreset
            onClick={(): void => {}}
            title="Анапа"
            secondRow="2 гостя"
            thirdRow="26 сен — 2 окт"
            Icon={HotelIcon}
        />
        <Heading level="3">Trains</Heading>
        <SearchPreset
            onClick={(): void => {}}
            title="Анапа — Москва"
            secondRow="2 окт"
            Icon={TrainIcon}
        />
        <Heading level="3">Buses</Heading>
        <SearchPreset
            onClick={(): void => {}}
            title="Екатеринбург — Пермь"
            sideTitle={<Price value={30} currency={CurrencyType.RUB} isRound />}
            secondRow="8:10"
            thirdRow="Сегодня"
            Icon={BusIcon}
        />
        <Heading level="3">No icon</Heading>
        <SearchPreset
            onClick={(): void => {}}
            title="Какой-то title"
            secondRow="Какой-то second text"
            thirdRow="Какой-то third text"
        />
    </Flex>
);

export const Themes: TStorybookFunctionComponent = (): React.ReactElement => (
    <Flex style={{backgroundColor: 'white', padding: '20px'}}>
        <Heading level="3">Default</Heading>
        <SearchPreset
            onClick={(): void => {}}
            title="Москва - Анапа"
            secondRow="4 пасажира"
            thirdRow="26 сен - 2 окт"
            Icon={FlightIcon}
        />
        <Heading level="3">Blue</Heading>
        <SearchPreset
            onClick={(): void => {}}
            title="Анапа"
            secondRow="2 гостя"
            thirdRow="26 сен - 2 окт"
            Icon={HotelIcon}
            theme="blue"
        />
    </Flex>
);

export const Width: TStorybookFunctionComponent = (): React.ReactElement => (
    <Flex style={{backgroundColor: 'white', padding: '20px'}}>
        <Flex flexDirection="column">
            <Heading level="3">Auto</Heading>
            <SearchPreset
                onClick={(): void => {}}
                title="Москва - Анапа"
                secondRow="4 пасажира"
                thirdRow="26 сен - 2 окт"
                Icon={FlightIcon}
            />
        </Flex>
        <Box style={{width: '100%', border: '2px solid red'}}>
            <Heading level="3">Max</Heading>
            <SearchPreset
                onClick={(): void => {}}
                title="Анапа"
                secondRow="2 гостя"
                thirdRow="26 сен - 2 окт"
                Icon={HotelIcon}
                width="max"
            />
        </Box>
    </Flex>
);
