import React, {ReactNode} from 'react';

import {IIconProps} from 'icons/types/icon';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import Intersperse from 'components/Intersperse/Intersperse';
import DotSeparator from 'components/DotSeparator/DotSeparator';

import cx from './SearchPreset.scss';

interface ISearchPresetProps extends IWithClassName {
    title: string;
    sideTitle?: ReactNode;
    secondRow: ReactNode;
    thirdRow?: ReactNode;
    Icon?: React.FunctionComponent<IIconProps>;
    theme?: 'default' | 'blue';
    onClick(): void;
    width?: 'auto' | 'max';
    bottomText?: ReactNode;
}

const SearchPreset: React.FC<ISearchPresetProps> = ({
    className,
    title,
    sideTitle,
    secondRow,
    thirdRow,
    Icon,
    theme = 'default',
    onClick,
    width = 'auto',
    bottomText,
}) => {
    const deviceType = useDeviceType();

    return (
        <Flex
            className={cx(
                'root',
                deviceMods('root', deviceType),
                `root_width_${width}`,
                `root_theme_${theme}`,
                className,
            )}
            flexDirection="column"
            onClick={onClick}
        >
            <Flex flexDirection="column" className={cx('mainInfo')}>
                <Flex alignItems="center" inline nowrap>
                    <Intersperse separator={<DotSeparator />}>
                        <Text
                            className={cx('title')}
                            tagProps={{title}}
                            size="m"
                            weight="bold"
                            color={theme === 'blue' ? 'link' : 'primary'}
                            whiteSpace="nowrap"
                        >
                            {title}
                        </Text>

                        {sideTitle && (
                            <Text
                                size="m"
                                weight="bold"
                                color={theme === 'blue' ? 'link' : 'primary'}
                                whiteSpace="nowrap"
                            >
                                {sideTitle}
                            </Text>
                        )}
                    </Intersperse>
                </Flex>

                {secondRow && (
                    <Text
                        size="s"
                        color={theme === 'blue' ? 'link' : 'primary'}
                        whiteSpace="nowrap"
                    >
                        {secondRow}
                    </Text>
                )}

                {thirdRow && (
                    <Text
                        size="s"
                        color={theme === 'blue' ? 'link-pale' : 'secondary'}
                        whiteSpace="nowrap"
                    >
                        {thirdRow}
                    </Text>
                )}
            </Flex>

            {bottomText && <div className={cx('bottomText')}>{bottomText}</div>}

            {Icon && <Icon className={cx('icon')} />}
        </Flex>
    );
};

export default React.memo(SearchPreset);
