import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import SearchSubmitButton from './SearchSubmitButton';

export default {
    title: 'Example/SearchSubmitButton',
    component: SearchSubmitButton,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => <SearchSubmitButton />;

export const Custom: TStorybookFunctionComponent = () => (
    <>
        <style>
            {`
                .submitButton {
                    box-shadow: 0 3px 8px -3px rgba(0, 0, 0, .1);
                }
            `}
        </style>
        <SearchSubmitButton
            className="searchButton"
            isSimple={true}
            label="Press me"
            onClick={(): void => alert('click')}
        />
    </>
);
