import React, {MouseEventHandler, FormEventHandler} from 'react';
import _noop from 'lodash/noop';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18nNew/components';

import cx from './SearchSubmitButton.scss';

interface ISearchSubmitButtonProps extends IWithClassName, IWithQaAttributes {
    label?: string;
    tabIndex?: number | string;
    isSimple?: boolean;
    onClick?: MouseEventHandler;
    onSubmit?: FormEventHandler;
}

const SearchSubmitButton: React.FC<ISearchSubmitButtonProps> = props => {
    const {
        onClick = _noop,
        onSubmit = _noop,
        className,
        label = i18nBlock.searchSubmitButtonDotDefaultLabel(),
        tabIndex = 0,
        isSimple = false,
    } = props;

    return (
        <button
            type="submit"
            className={cx(
                'submitButton',
                {
                    submitButton_simple_yes: isSimple,
                },
                className,
            )}
            tabIndex={Number(tabIndex)}
            onClick={onClick}
            onSubmit={onSubmit}
            {...prepareQaAttributes(props)}
        >
            <div className={cx('text')}>{label}</div>
        </button>
    );
};

export default SearchSubmitButton;
