import React, {ReactNode} from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import WatchIcon from 'icons/16/Watch';
import Text from 'components/Text/Text';

import {ISuggestItemHandlers} from '../../SearchSuggest';

import cx from './PreviousSearchSuggest.scss';

export interface IPreviousSearchSuggestProps
    extends IWithDeviceType,
        IWithQaAttributes {
    groupName: string | null;
    isActiveElement: boolean;
    title: string | ReactNode;
    description?: string | ReactNode;
    suggestItemHandlers?: ISuggestItemHandlers;
}

function PreviousSearchSuggest({
    groupName,
    isActiveElement,
    title,
    description,
    suggestItemHandlers,
    deviceType,
    ...rest
}: IPreviousSearchSuggestProps): React.ReactElement {
    return (
        <>
            {groupName && (
                <Text
                    className={cx('suggestListTitle')}
                    size="s-inset"
                    color="primary"
                    tag="div"
                >
                    {groupName}
                </Text>
            )}

            <Flex
                className={cx(
                    'suggestItem',
                    {
                        suggestItem_active: isActiveElement,
                    },
                    deviceMods('suggestItem', deviceType),
                )}
                justifyContent="flex-start"
                alignItems="center"
                tagProps={{...suggestItemHandlers}}
                {...prepareQaAttributes(rest)}
            >
                <WatchIcon className={cx('watchIcon')} />

                <Flex flexDirection="column">
                    <Text
                        className={cx('suggestItemTitle')}
                        size="m"
                        color="primary"
                        {...prepareQaAttributes({
                            parent: rest,
                            current: 'title',
                        })}
                    >
                        {title}
                    </Text>
                    {description && (
                        <Text size="s" color="secondary">
                            {description}
                        </Text>
                    )}
                </Flex>
            </Flex>
        </>
    );
}

export default PreviousSearchSuggest;
