import _uniqBy from 'lodash/uniqBy';

import {TSelectedValue} from 'components/SearchSuggest/SearchSuggest';

export interface IGetItemsByPreviousSearchParams<SuggestItem> {
    items: SuggestItem[];
    canRenderPreviousSearch: boolean;
    previousSuggestItems: SuggestItem[];
    otherField: TSelectedValue<SuggestItem>;
    maxPreviousCount: number;
    maxCount: number;
    uniqueValueName: keyof SuggestItem;

    sortItems?: (a: SuggestItem, b: SuggestItem) => number;
}

export default function getItemsByPreviousSearch<S>({
    items,
    canRenderPreviousSearch,
    previousSuggestItems,
    otherField,
    maxPreviousCount,
    maxCount,
    uniqueValueName,
    sortItems,
}: IGetItemsByPreviousSearchParams<S>): S[] {
    if (canRenderPreviousSearch) {
        let preparedSuggestItems = previousSuggestItems;

        if (otherField) {
            preparedSuggestItems = previousSuggestItems.filter(
                item => item[uniqueValueName] !== otherField[uniqueValueName],
            );
        }

        preparedSuggestItems = preparedSuggestItems.slice(0, maxPreviousCount);

        const uniqueItems = _uniqBy(
            [...preparedSuggestItems, ...items],
            uniqueValueName,
        );

        if (sortItems) {
            uniqueItems.sort(sortItems);
        }

        return uniqueItems.slice(0, maxCount);
    }

    return items;
}
