import {ParsedQuery} from 'query-string';

import {
    ETextBlocksType,
    TLinkTextBlock,
} from 'types/common/seoPages/ITextBlocks';

import {hotelsURLs} from 'projects/depreacted/hotels/utilities/urls';
import {getSearchPageQueryByGeoRegionInfo} from 'projects/depreacted/hotels/utilities/getSearchPageQueryByGeoRegionInfo/getSearchPageQueryByGeoRegionInfo';

const getLinkUrlByBlockType = (
    block: TLinkTextBlock,
    queryByLocation: ParsedQuery,
): string | null => {
    switch (block.type) {
        case ETextBlocksType.externalLinkBlock: {
            const {
                data: {url},
            } = block;

            return url;
        }

        case ETextBlocksType.hotelLinkBlock: {
            const {
                data: {
                    urlParams: {hotelSlug},
                },
            } = block;

            return hotelsURLs.getHotelUrl({hotelSlug}, queryByLocation);
        }

        case ETextBlocksType.regionLinkBlock: {
            const {
                data: {
                    urlParams: {regionSlug, filterSlug},
                },
            } = block;

            return hotelsURLs.getRegionUrl({regionSlug, filterSlug});
        }

        case ETextBlocksType.searchHotelsLinkBlock: {
            const {
                data: {urlParams},
            } = block;

            const searchHotelsQueryParams =
                getSearchPageQueryByGeoRegionInfo(urlParams);

            return hotelsURLs.getSearchUrlWithQuery(searchHotelsQueryParams);
        }

        default: {
            return null;
        }
    }
};

export default getLinkUrlByBlockType;
