import React from 'react';
import {connect} from 'react-redux';

import {StoreInterface} from 'reducers/storeTypes';

import environmentConfigSelector from 'selectors/common/environmentConfigSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

const enhancer = connect((state: StoreInterface) => ({
    secureIFramePath: environmentConfigSelector(state)
        .secureIFramePath as string,
}));

interface ISecureIFrameProxyProps
    extends React.IframeHTMLAttributes<HTMLIFrameElement>,
        IWithQaAttributes {
    secureIFramePath: string;
    frameRef?: React.Ref<HTMLIFrameElement>;
}

const SecureIFrameProxy = enhancer(
    ({src, secureIFramePath, frameRef, ...rest}: ISecureIFrameProxyProps) => (
        <iframe
            {...rest}
            ref={frameRef}
            src={`${secureIFramePath}?url=${src && encodeURIComponent(src)}`}
            {...prepareQaAttributes(rest)}
        />
    ),
);

export default SecureIFrameProxy;
