import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';

import Separator from './Separator';

export default {
    title: 'Example/Separator',
    component: Separator,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <div>
        <span>Hello</span>
        <Separator />
        <span>World</span>
    </div>
);

export const WithMargin: TStorybookFunctionComponent = () => (
    <Box between="5">
        <div>
            <span>Hello</span>
            <Separator margin={1} />
            <span>World</span>
        </div>
        <div>
            <span>Hello</span>
            <Separator margin={2} />
            <span>World</span>
        </div>
    </Box>
);
WithMargin.parameters = {
    info: {
        comment: 'Пропса `margin` задает отступ сверху и снизу от разделителя',
    },
};

export const Vertical: TStorybookFunctionComponent = () => (
    <div>
        <span>Hello</span>
        <Separator isVertical margin={2} height={30} />
        <span>World</span>
        <Separator isVertical margin={2} height={30} />
        <span>Again</span>
    </div>
);
