import React from 'react';

import {IWithClassName} from 'types/withClassName';
import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {IPopupProps} from 'components/Popup/Popup';
import Dropdown from 'components/Dropdown/Dropdown';
import {ShareDropoutButton} from './components/ShareDropoutButton/ShareDropoutButton';
import {ShareDropoutPopup} from './components/ShareDropoutPopup/ShareDropoutPopup';

const POPUP_PROPS: Partial<IPopupProps> = {
    directions: [EPopupDirection.BOTTOM_RIGHT],
};

interface IShareDropoutState {
    toggleForTinyUrl: boolean;
}

export class ShareDropout extends React.PureComponent<
    IWithClassName,
    IShareDropoutState
> {
    readonly state: IShareDropoutState = {
        toggleForTinyUrl: false,
    };

    private restoreTinyUrl = (): void => {
        this.setState({toggleForTinyUrl: !this.state.toggleForTinyUrl});
    };

    render(): React.ReactNode {
        const {className} = this.props;

        const popupComponentProps = {
            toggleForTinyUrl: this.state.toggleForTinyUrl,
        };

        return (
            <Dropdown
                switcherComponent={ShareDropoutButton}
                popupComponent={ShareDropoutPopup}
                popupProps={POPUP_PROPS}
                onHidePopup={this.restoreTinyUrl}
                switcherClassName={className}
                popupComponentProps={popupComponentProps}
            />
        );
    }
}

export default ShareDropout;
