import React from 'react';

import {IInputChangeEvent} from 'components/Input/types/InputProps';

import {socialNetsInDefaultOrder} from 'components/ShareLink/utilities/socialNets';
import getSocialSharingNetText from './utilities/getSocialSharingNetText';

import Box from 'components/Box/Box';
import Input from 'components/Input/Input';
import Separator from 'components/Separator/Separator';
import {ShareLink} from 'components/ShareLink/ShareLink';
import {
    withUpdateTinyUrl,
    IUpdateLink,
} from 'components/withUpdateTinyUrl/withUpdateTinyUrl';
import {IDropdownPopupParams} from 'components/Dropdown/Dropdown';

import cx from './ShareDropoutPopup.scss';

type TShareDropoutPopupProps = IUpdateLink &
    IDropdownPopupParams<{
        // чтобы восстановить урл, если он был изменён пользователем
        toggleForTinyUrl: boolean;
    }>;

interface IShareDropoutPopupState {
    inputValue: string;
}

class _ShareDropoutPopup extends React.PureComponent<
    TShareDropoutPopupProps,
    IShareDropoutPopupState
> {
    private readonly inputRef = React.createRef<Input>();

    readonly state: IShareDropoutPopupState = {
        inputValue: this.props.tinyUrl,
    };

    componentDidUpdate(prevProps: TShareDropoutPopupProps): void {
        if (
            prevProps.tinyUrl !== this.props.tinyUrl ||
            prevProps.componentProps.toggleForTinyUrl !==
                this.props.componentProps.toggleForTinyUrl
        ) {
            this.setState({inputValue: this.props.tinyUrl});
        }
    }

    private renderInput(): React.ReactNode {
        return (
            <div className={cx('inputWrapper')}>
                <Input
                    className={cx('input-for-url')}
                    value={this.state.inputValue}
                    ref={this.inputRef}
                    onChange={this.onChange}
                    onFocus={this.onFocus}
                />
            </div>
        );
    }

    private renderSocialLinks(): React.ReactNode {
        return (
            <div className={cx('listVertical')}>
                {socialNetsInDefaultOrder.map(type => (
                    <ShareLink
                        key={type}
                        type={type}
                        url={this.props.tinyUrl}
                        directionStyle="vertical"
                        textAfter={getSocialSharingNetText(type)}
                    />
                ))}
            </div>
        );
    }

    private onChange = (event: IInputChangeEvent, inputValue: string): void =>
        this.setState({inputValue});

    private onFocus = (): void => {
        if (this.inputRef.current) {
            this.inputRef.current.select();
        }
    };

    render(): React.ReactNode {
        return (
            <Box className={cx('root')}>
                {this.renderInput()}
                <Separator margin={1} />
                {this.renderSocialLinks()}
            </Box>
        );
    }
}

export const ShareDropoutPopup = withUpdateTinyUrl(_ShareDropoutPopup);
