import {IIconProps} from 'icons/types/icon';

import Vkontakte from 'components/ShareLink/icons/Vkontakte';
import Twitter from 'components/ShareLink/icons/Twitter';
import Facebook from 'components/ShareLink/icons/Facebook';

export enum SocialSharingNets {
    VK = 'vk',
    Twitter = 'twitter',
    Facebook = 'facebook',
}

type ISocialNetToData = {
    [key in SocialSharingNets]: {
        size: {
            width: number;
            height: number;
        };
        hrefStart: string;
        iconComponent: React.FC<IIconProps>;
    };
};

// Размер окон для разных соц. сетей, взял из скрипта share.yandex.ru
export const socialNetToData: ISocialNetToData = {
    [SocialSharingNets.VK]: {
        size: {
            width: 550,
            height: 420,
        },
        hrefStart: 'https://vk.com/share.php?url=',
        iconComponent: Vkontakte,
    },
    [SocialSharingNets.Twitter]: {
        size: {
            width: 650,
            height: 520,
        },
        hrefStart: 'https://twitter.com/intent/tweet?url=',
        iconComponent: Twitter,
    },
    [SocialSharingNets.Facebook]: {
        size: {
            width: 800,
            height: 500,
        },
        hrefStart: 'https://facebook.com/sharer.php?href=',
        iconComponent: Facebook,
    },
};

export const socialNetsInDefaultOrder = [
    SocialSharingNets.VK,
    SocialSharingNets.Twitter,
    SocialSharingNets.Facebook,
];
