import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import Heading from 'components/Heading/Heading';
import Box from 'components/Box/Box';

import ButtonSkeleton from './ButtonSkeleton';

export default {
    title: 'Example/Skeletons/ButtonSkeleton',
    component: ButtonSkeleton,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <>
        <style>
            {`
                .button {
                    width: 100px;
                }
            `}
        </style>
        <StyleguidistSizeTable
            sizes={[
                's' as const,
                'm' as const,
                'm-inset' as const,
                'l' as const,
                'xl' as const,
            ].map(size => ({
                name: size,
                example: <ButtonSkeleton className="button" size={size} />,
            }))}
        />
    </>
);
Simple.parameters = {
    info: {
        title: 'Элемент кнопки для скелетона',
        comment: 'Высота элемента равна высоте кнопки соотвествующего размера',
    },
};

export const Shapes: TStorybookFunctionComponent = () => (
    <>
        <style>
            {`
                .button {
                    width: 100px;
                }
            `}
        </style>
        <Box between={5}>
            <Box between={3}>
                <Heading level="3">Круглая</Heading>
                <ButtonSkeleton shape="circle" />
            </Box>
            <Box between={3}>
                <Heading level="3">Прямоугольная</Heading>
                <ButtonSkeleton className="button" />
            </Box>
        </Box>
    </>
);
