import React, {CSSProperties} from 'react';

import {IWithClassName} from 'types/withClassName';

import {TButtonSize} from 'components/Button/Button';

import cx from './ButtonSkeleton.scss';

export interface IButtonSkeletonProps extends IWithClassName {
    size?: TButtonSize;
    style?: CSSProperties;
    withAnimation?: boolean;
    shape?: 'circle';
}

const ButtonSkeleton: React.FC<IButtonSkeletonProps> = ({
    className,
    size = 'm-inset',
    style,
    withAnimation = false,
    shape,
}) => (
    <div
        className={cx(
            'root',
            `root_size_${size}`,
            shape && `root_shape_${shape}`,
            {root_withAnimation: withAnimation},
            className,
        )}
        style={style}
    />
);

export default ButtonSkeleton;
