import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import TextSkeleton, {ITextSkeletonProps} from './TextSkeleton';

export default {
    title: 'Example/Skeletons/TextSkeleton',
    component: TextSkeleton,
} as Meta;

const SIZES: NonNullable<ITextSkeletonProps['size']>[] = [
    'xxs',
    'xs',
    's',
    'm',
    'l',
    'xl',
    'xxl',
];

export const Simple: TStorybookFunctionComponent = () => (
    <>
        <style>
            {`
                .textRow {
                    width: 200px;
                }
            `}
        </style>

        <StyleguidistSizeTable
            sizes={SIZES.map(size => ({
                name: size,
                example: <TextSkeleton className="textRow" size={size} />,
            }))}
        />
    </>
);
Simple.parameters = {
    info: {
        title: 'Элемент теста для скелетона',
        comment:
            'Общая высота элемента равна line-height текста соотвествующего размера. Высота закрашенной части равна font-size текста соотвествующего размера. Закрашенная часть располагается по центру',
    },
};
