import React from 'react';

import {IWithClassName} from 'types/withClassName';

import cx from './TextSkeleton.scss';

export interface ITextSkeletonProps extends IWithClassName {
    size?: 'xxl' | 'xl' | 'l' | 'm' | 's' | 'xs' | 'xxs';
    theme?: 'default' | 'labelSecondary';
    withAnimation?: boolean;
}

const TextSkeleton: React.FC<ITextSkeletonProps> = ({
    className,
    size = 'm',
    theme = 'default',
    withAnimation = false,
}) => (
    <div
        className={cx(
            `root_size_${size}`,
            `root_theme_${theme}`,
            {root_withAnimation: withAnimation},
            className,
        )}
    />
);

export default TextSkeleton;
