import React, {ReactNode, useEffect, useState} from 'react';
import ReactDOM from 'react-dom';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import cx from './Snackbar.scss';

interface ISnackbarProps extends IWithClassName {
    isVisible: boolean;
    size?: 's';
    theme?: 'primary' | 'light';
    children?: ReactNode;
}

const Snackbar: React.FC<ISnackbarProps> = ({
    isVisible,
    size = 's',
    theme = 'primary',
    className,
    children,
}) => {
    const deviceType = useDeviceType();

    const [canRender, setCanRender] = useState(false);

    useEffect(() => {
        setCanRender(true);
    }, []);

    if (!canRender) {
        return null;
    }

    return ReactDOM.createPortal(
        <div
            className={cx(
                'root',
                `root_size_${size}`,
                `root_theme_${theme}`,
                {
                    root_visible: isVisible,
                },
                deviceMods('root', deviceType),
                className,
            )}
        >
            {children}
        </div>,
        document.body,
    );
};

export default React.memo(Snackbar);
