import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {ESortType} from 'types/common/sort/ESortType';
import {ESortDirection} from 'types/common/sort/ESortDirection';

import SortDesktop from './SortDesktop';

export default {
    title: 'Example/SortDesktop',
    component: SortDesktop,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <SortDesktop
        type={ESortType.DURATION}
        direction={ESortDirection.ASC}
        onClick={(type, direction): void => console.log(type, direction)}
    />
);
Simple.parameters = {
    info: {
        title: 'Панель сортировок в десктопе',
    },
};
