import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {ESortType} from 'types/common/sort/ESortType';
import {ESortDirection} from 'types/common/sort/ESortDirection';

import SortMobile from './SortMobile';

export default {
    title: 'Example/SortMobile',
    component: SortMobile,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <SortMobile
        type={ESortType.DURATION}
        direction={ESortDirection.ASC}
        onChange={(type, direction): void => console.log(type, direction)}
    />
);
Simple.parameters = {
    info: {
        title: 'Блок сортировок в таче',
    },
};
