import {compose, composeU} from '@bem-react/core';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {
    Spin as LegoDesktopSpin,
    ISpinProps as ILegoSpinProps,
    withViewDefault,
} from '@yandex-lego/components/Spin';

/** Size mods */
import {withSizeXXS} from '../_size/Spinner_size_xxs';
import {withSizeXS} from '../_size/Spinner_size_xs';
import {withSizeS} from '../_size/Spinner_size_s';
import {withSizeM} from '../_size/Spinner_size_m';
import {withSizeL} from '../_size/Spinner_size_l';
import {withSizeXL} from '../_size/Spinner_size_xl';
import {withSizeXXL} from '../_size/Spinner_size_xxl';
/** View mods */
import {cnSpinner} from '../cnSpinner';

const YTLegoSpinWrapper = (props: ILegoSpinProps & IWithQaAttributes) => {
    const {className, innerRef, progress} = props;

    return (
        <LegoDesktopSpin
            className={cnSpinner(null, [className])}
            innerRef={innerRef}
            progress={progress}
            {...prepareQaAttributes(props)}
        />
    );
};

export const SpinnerPresenter = compose(
    composeU(
        withSizeXXS,
        withSizeXS,
        withSizeS,
        withSizeM,
        withSizeL,
        withSizeXL,
        withSizeXXL,
    ),
    composeU(withViewDefault),
)(YTLegoSpinWrapper);
