import {FunctionComponent} from 'react';
import _times from 'lodash/times';

import {IWithClassName} from 'types/withClassName';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

/* Components */
import StarIcon from 'icons/12/Star';

/* Init Styles */
import cx from './Stars.scss';

/* Components types */
interface IStarsProps extends IWithClassName {
    totalStarCount: number;
    starCount: number;
}

export const Stars: FunctionComponent<IStarsProps> = props => {
    const {className, totalStarCount} = props;
    const starsList = _times(totalStarCount);

    return (
        <div
            className={cx('stars', className)}
            {...prepareQaAttributes('stars')}
        >
            {starsList.map((index: number) => (
                <div
                    key={index}
                    className={cx('star', {
                        star_isActive: index < props.starCount,
                    })}
                >
                    <StarIcon className={cx('starIcon')} />
                </div>
            ))}
        </div>
    );
};

export default Stars;
