import React, {FunctionComponent, ReactNode} from 'react';

import Text from 'components/Text/Text';
import {Td} from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

export interface IPropDescription {
    name: string;
    props: Record<string, unknown>;
    example: ReactNode;
    comment?: string;
}

export interface IStyleguidistSizeTableProps {
    props: IPropDescription[];
}

const Row: FunctionComponent<IPropDescription> = ({
    name,
    example,
    props,
    comment,
}) => {
    return (
        <tr>
            <Td>
                <Text size="l" weight="bold">
                    {name}
                </Text>
            </Td>
            <Td>{example}</Td>
            <Td>
                <code>
                    {Object.entries(props).map(
                        ([name, value]): React.ReactNode => (
                            <div key={name}>{`${name}=${value}`}</div>
                        ),
                    )}
                </code>
            </Td>
            {comment && <Td>{comment}</Td>}
        </tr>
    );
};

const StyleguidistPropTable: FunctionComponent<IStyleguidistSizeTableProps> = ({
    props,
}) => {
    return (
        <table>
            <tbody>
                {props.map(prop => (
                    <Row {...prop} key={prop.name} />
                ))}
            </tbody>
        </table>
    );
};

export default StyleguidistPropTable;
