import {FunctionComponent, ReactNode} from 'react';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import {Center} from 'projects/avia/components/Center/Center';

import cx from './StyleguidistSizeTable.scss';

export interface ISizeDescription {
    name: string;
    size?: string;
    example: ReactNode | (() => ReactNode);
    comment?: string;
}

export interface IStyleguidistSizeTableProps {
    sizes: ISizeDescription[];
}

export const Td = (props: {children: ReactNode}) => (
    <td>
        <Box inset="2" between="4" inline {...props} />
    </td>
);

const Row = ({name, example, size, comment}: ISizeDescription) => {
    return (
        <tr>
            <Td>
                <Text size="l" className={cx('sizeName')}>
                    {name}
                </Text>
            </Td>
            <Td>{typeof example === 'function' ? example() : example}</Td>
            <Td>
                <Text size="s" className={cx('size')}>
                    <Center x="2" style={{lineHeight: size}}>
                        {size}
                    </Center>
                </Text>
            </Td>
            <Td>
                <code>size=&quot;{name}&quot;</code>
            </Td>
            {comment && <Td>{comment}</Td>}
        </tr>
    );
};

const StyleguidistSizeTable: FunctionComponent<IStyleguidistSizeTableProps> = ({
    sizes,
}) => {
    return (
        <table>
            <tbody>
                {sizes.map(props => (
                    <Row {...props} key={props.name} />
                ))}
            </tbody>
        </table>
    );
};

export default StyleguidistSizeTable;
