import {IPromoCodeForSubscription} from 'server/api/NotifierApi/types';
import {TPictureSize} from '../../../types/TPictureSize';

import PromoPercentM from 'icons/images/PromoPercentM.svg';
import PromoPercentS from 'icons/images/PromoPercentS.svg';
import PromoPercentXS from 'icons/images/PromoPercentXS.svg';
import Promo500M from 'icons/images/Promo500M.svg';
import Promo500S from 'icons/images/Promo500S.svg';
import Promo500XS from 'icons/images/Promo500XS.svg';
import Promo10M from 'icons/images/Promo10M.svg';
import Promo10S from 'icons/images/Promo10S.svg';
import Promo10XS from 'icons/images/Promo10XS.svg';

type TPictureSizes = {
    [key in TPictureSize]: {
        width: number;
        height: number;
    };
};

export const PICTURE_SIZES: TPictureSizes = {
    m: {
        width: 307,
        height: 180,
    },
    s: {
        width: 280,
        height: 193,
    },
    xs: {
        width: 137,
        height: 102,
    },
};

interface IPictureNameToSizes {
    percent: Record<TPictureSize, string>;
    fix500: Record<TPictureSize, string>;
    percent10: Record<TPictureSize, string>;
}

const pictureNameToSizes: IPictureNameToSizes = {
    percent: {
        m: PromoPercentM,
        s: PromoPercentS,
        xs: PromoPercentXS,
    },
    fix500: {
        m: Promo500M,
        s: Promo500S,
        xs: Promo500XS,
    },
    percent10: {
        m: Promo10M,
        s: Promo10S,
        xs: Promo10XS,
    },
};

export function getPromoCodePictureSource(
    {type, amount}: IPromoCodeForSubscription,
    size: TPictureSize,
): string {
    if (type === 'ESubscriptionPromoCodeType.FIX' && amount === 500) {
        return pictureNameToSizes.fix500[size];
    } else if (type === 'ESubscriptionPromoCodeType.PERCENT' && amount === 10) {
        return pictureNameToSizes.percent10[size];
    }

    return pictureNameToSizes.percent[size];
}
