import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18nNew/promoCodeForSubscription';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Link from 'components/Link/Link';
import Flex from 'components/Flex/Flex';
import Heading from 'components/Heading/Heading';
import SubscriptionForm, {
    ISubscriptionFormProps,
} from 'components/SubscriptionForm/SubscriptionForm';

import cx from './SubscriptionWithoutPromoCode.scss';

export interface ISubscriptionWithoutPromoCodeProps
    extends Omit<ISubscriptionFormProps, 'theme'> {
    /** Настройка для десктопного отображения на поиске / на главной */
    headerSize?: 'xl' | 'xxl';
}

const SubscriptionWithoutPromoCode: React.FC<ISubscriptionWithoutPromoCodeProps> =
    props => {
        const {className, headerSize, ...rest} = props;
        const deviceType = useDeviceType();
        const {isDesktop} = deviceType;

        return (
            <Flex
                className={cx(
                    'root',
                    deviceMods('root', deviceType),
                    className,
                )}
                flexDirection={isDesktop ? 'row' : 'column'}
                alignItems="center"
                between={isDesktop ? 10 : 5}
                inline={isDesktop}
                nowrap={isDesktop}
            >
                <Box className={cx('column')} between="2">
                    <Heading
                        level={2}
                        className={cx(
                            'title',
                            headerSize && `title_size_${headerSize}`,
                        )}
                    >
                        {i18nBlock.baseTitle()}
                    </Heading>

                    <Text className={cx('text')} size="m">
                        {i18nBlock.baseSubtitle()}
                    </Text>
                </Box>

                <Box className={cx('column')} between="2">
                    <SubscriptionForm
                        className={cx('form')}
                        buttonClassName={cx('submit')}
                        inputClassName={cx('input')}
                        showErrorsInTooltip
                        size="m-inset"
                        {...rest}
                    />

                    <Text size="s">
                        {insertJSXIntoKey(i18nBlock.acceptTerms)({
                            link: (
                                <Link
                                    url={i18nBlock.userAgreementLink()}
                                    theme="normal"
                                    target="_blank"
                                >
                                    {i18nBlock.userAgreement()}
                                </Link>
                            ),
                        })}
                    </Text>
                </Box>
            </Flex>
        );
    };

export default SubscriptionWithoutPromoCode;
