import {EFormKey} from 'constants/form/EFormKey';
import {getEmailValidationRegExp} from 'constants/form/validationRules';

import {IFormValidationInfo} from 'types/common/validation/form';
import {EValidationType} from 'types/common/validation/validation';
import {EGroupName, EFieldName} from '../types/form';

import * as i18nBlock from 'i18nNew/components-SubscriptionModal';

const subscriptionModalValidation: IFormValidationInfo = {
    id: EFormKey.MODAL_SUBSCRIPTION,

    fieldGroups: [
        {
            id: EGroupName.contacts,
            fields: [
                {
                    name: EFieldName.email,
                    validation: {
                        submit: [
                            {
                                type: EValidationType.required,
                                params: true,
                                errorMessage: i18nBlock.emailRequired(),
                            },
                            {
                                type: EValidationType.regex,
                                params: getEmailValidationRegExp(),
                                errorMessage: i18nBlock.emailWrong(),
                            },
                        ],
                    },
                },
            ],
        },
    ],
};

export default subscriptionModalValidation;
