import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {ESubscriptionPromoCodeType} from 'types/subscription/ESubscriptionPromoCodeType';

import {IDevice} from 'reducers/common/commonReducerTypes';

import DeviceTypeContext from 'contexts/DeviceTypeContext';
import LayersContext from 'contexts/LayersContext';

import SubscriptionInline from './SubscriptionInline';

export default {
    title: 'Example/SubscriptionInline',
    component: SubscriptionInline,
} as Meta;

const deviceTypeDefault: IDevice = {
    isTouch: false,
    isIe: false,
    os: {name: '', version: ''},
    browser: {name: '', version: ''},
    isMobile: false,
    isDesktop: false,
};

export const Desktop: TStorybookFunctionComponent = () => {
    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isDesktop: true}}
        >
            <LayersContext.Provider value={20}>
                <SubscriptionInline
                    onSubmit={() => {}}
                    type="wide"
                    headerSize="xxl"
                />
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};

export const DesktopFix: TStorybookFunctionComponent = () => {
    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isDesktop: true}}
        >
            <LayersContext.Provider value={20}>
                <SubscriptionInline
                    onSubmit={() => {}}
                    type="thin"
                    promoCode={{
                        type: ESubscriptionPromoCodeType.FIX,
                        amount: 500,
                        minTotalCost: 3000,
                    }}
                />
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};

export const DesktopPercent: TStorybookFunctionComponent = () => {
    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isDesktop: true}}
        >
            <LayersContext.Provider value={20}>
                <SubscriptionInline
                    onSubmit={() => {}}
                    type="thin"
                    promoCode={{
                        type: ESubscriptionPromoCodeType.PERCENT,
                        amount: 10,
                    }}
                />
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};

export const Mobile: TStorybookFunctionComponent = () => {
    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isMobile: true}}
        >
            <LayersContext.Provider value={20}>
                <div style={{width: 360}}>
                    <SubscriptionInline onSubmit={() => {}} />
                </div>
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};

export const MobileFix: TStorybookFunctionComponent = () => {
    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isMobile: true}}
        >
            <LayersContext.Provider value={20}>
                <div style={{width: 360}}>
                    <SubscriptionInline
                        onSubmit={() => {}}
                        promoCode={{
                            type: ESubscriptionPromoCodeType.FIX,
                            amount: 3000,
                        }}
                    />
                </div>
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};

export const MobilePercent: TStorybookFunctionComponent = () => {
    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isMobile: true}}
        >
            <LayersContext.Provider value={20}>
                <div style={{width: 360}}>
                    <SubscriptionInline
                        onSubmit={() => {}}
                        promoCode={{
                            type: ESubscriptionPromoCodeType.PERCENT,
                            amount: 50,
                            minTotalCost: 500,
                        }}
                    />
                </div>
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};
