import React, {useRef} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Card from 'components/Card/Card';
import SubscriptionContent, {
    ISubscriptionContentProps,
} from 'components/SubscriptionContent/SubscriptionContent';

import ScopeContext from 'contexts/ScopeContext';

import cx from './SubscriptionInline.scss';

export interface ISubscriptionInlineProps
    extends Omit<
        ISubscriptionContentProps,
        'pictureSize' | 'pictureClassName'
    > {
    /** Настройки для десктопного отображения на поиске / на главной */
    type?: 'thin' | 'wide';
    headerSize?: 'xl' | 'xxl';
}

const SubscriptionInline: React.FC<ISubscriptionInlineProps> = props => {
    const {className, type, ...rest} = props;
    const deviceType = useDeviceType();

    const cardRef = useRef<HTMLElement>(null);

    return (
        <Card
            className={cx(
                'root',
                deviceMods('root', deviceType),
                className,
                type && `root_type_${type}`,
            )}
            ref={cardRef}
            shadow="default"
        >
            <ScopeContext.Provider value={cardRef.current || undefined}>
                <SubscriptionContent
                    pictureSize={deviceType.isDesktop ? 'm' : 'xs'}
                    pictureClassName={cx(
                        'picture',
                        deviceMods('picture', deviceType),
                    )}
                    {...rest}
                />
            </ScopeContext.Provider>
        </Card>
    );
};

export default SubscriptionInline;
