import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Button from 'components/Button/Button';

import LayersContext from 'contexts/LayersContext';

import SubscriptionModal from './SubscriptionModal';

export default {
    title: 'Example/SubscriptionModal',
    component: SubscriptionModal,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);

    return (
        <LayersContext.Provider value={20}>
            <Button onClick={(): void => setVisibility(true)}>
                Хочу подписаться
            </Button>

            <SubscriptionModal
                isVisible={isVisible}
                onClose={(): void => setVisibility(false)}
                onSubmit={(email: string): void => {
                    console.log(email);

                    setVisibility(false);
                }}
            />
        </LayersContext.Provider>
    );
};
